% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_class.R
\name{get_class}
\alias{get_class}
\title{Get class(es) in an ontology}
\usage{
get_class(..., regex = FALSE, external = FALSE, ontology = NULL)
}
\arguments{
\item{...}{combination of column name and value to filter that column by. The
value to filter by can be provided as regular expression, if \code{regex =
  TRUE}.}

\item{regex}{\code{\link[=logical]{logical(1)}}\cr whether or not the value in
\code{...} shall be matched in full, or whether any partial match should be
returned.}

\item{external}{\code{\link[=logical]{logical(1)}}\cr whether or not the external
classes (TRUE), or the harmonized classes should be returned (FALSE,
default).}

\item{ontology}{\code{\link[=list]{ontology(1)}}\cr either a path where the ontology is
stored, or an already loaded ontology.}
}
\value{
A table of the class(es) in the ontology according to the values in
\code{...}
}
\description{
Get class(es) in an ontology
}
\examples{
ontoDir <- system.file("extdata", "crops.rds", package = "ontologics")
onto <- load_ontology(path = ontoDir)

# exact classes from a loaded ontology ...
get_class(label = "class", ontology = onto)

# ... or one stored on the harddisc
get_class(id = ".xx.xx", ontology = ontoDir)

# use regular expressions ...
get_class(label = "ro", regex = TRUE, ontology = onto)

# get all sources
get_class(ontology = onto)
}
