% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_functions.R
\name{get_vector_ids_per_term}
\alias{get_vector_ids_per_term}
\title{Get vector layer IDs for single term}
\usage{
get_vector_ids_per_term(term = "HAO:0000349", ONT, GR)
}
\arguments{
\item{term}{character. An ontology term label to get the corresponding layer IDs in the Picture object.}

\item{ONT}{ontology_index object.}

\item{GR}{data.frame. A data.frame with the picture information. It contains the matches between all ontology term labels and layer IDs in the Picture object.
The first column corresponds to the ontology term labels, the second to the ontology IDs, and the third to the layer IDs in the Picture object.}
}
\value{
A named vector with the layer IDs corresponding to or descending from the ontology term label queried.
}
\description{
Given an ontology_index object, ontology term label, and data.frame with picture information (see examples),
produces a named vector with layer IDs to be used in the 'make_pic' function.
}
\examples{
data("HAO", "hym_graph")
# Get picture layers from head.
get_vector_ids_per_term(term = "HAO:0000397", ONT = HAO, GR = hym_graph)

}
\author{
Sergei Tarasov
}
