% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhpp_functions.R
\name{make_contMap_KDE}
\alias{make_contMap_KDE}
\title{Make contMap KDE object}
\usage{
make_contMap_KDE(tree.discr, Edge.KDE.stat)
}
\arguments{
\item{tree.discr}{phylo object. A discretized tree using the 'discr_Simmap' function.}

\item{Edge.KDE.stat}{list. A list with the distributions of the estimated parameter of KDEs for each edge.}
}
\value{
A 'contMap' object.
}
\description{
Produces a contMap object for plotting the NHPP.
}
\examples{
data("hym_tree", "hym_kde")
# Get reference tree.
tree_discr <- discr_Simmap(hym_tree, res = 200)
# Get smoothing of normalized edge KDE data for mean rates.
Edge_KDE <- hym_kde$head
Edge_KDE_stat <- Edge_KDE$loess.lambda.mean
# Make contmap nhpp data.
nhpp_map <- make_contMap_KDE(tree_discr, Edge_KDE_stat)
# Plot contmap.
phytools::plot.contMap(nhpp_map, lwd = 3, outline = FALSE,
legend = FALSE, ftype = "off", plot = FALSE)

}
\author{
Sergei Tarasov
}
