% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbstractClass.R
\name{AbstractClass}
\alias{AbstractClass}
\title{Create an abstract R6 Class}
\description{
Creates an abstract R6 class by placing a thin wrapper around \link[R6:R6Class]{R6::R6Class}
which causes an error to be thrown if the class is directly constructed
instead of one of its descendants.
}
\details{
An abstract class is a class that cannot be constructed directly.
Instead they are used to define common fields/methods for child classes
that inherit from them.

All arguments of \link[R6:R6Class]{R6::R6Class} can be used as usual, see full
details at \link[R6:R6Class]{R6::R6Class}.
}
\examples{
library(R6)

ab <- AbstractClass("abstract", public = list(hello = "Hello World"))
\dontrun{
# errors
ab$new()
}
child <- R6Class("child", inherit = ab)
child$new()$hello

}
\references{
Gamma, E., Helm, R., Johnson, R., & Vlissides, J. (1996).
Design Patterns: Elements of Reusable Software.
Addison-Wesley Professional Computing Series (p. 395).
}
