% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{convertPostcode}
\alias{convertPostcode}
\title{Convert a UK postcode to a latitude/longitude pair}
\source{
\url{https://postcodes.io/}
}
\usage{
convertPostcode(postcode)
}
\arguments{
\item{postcode}{\emph{A valid UK postcode.}

\strong{required}

A string containing a single valid UK postcode, e.g., \code{"SW1A 1AA"}.}
}
\value{
A list containing the latitude, longitude, and input postcode.
}
\description{
This is a much simpler implementation of the tools found in the
\code{PostcodesioR} R package, intended for use with the \code{\link[=searchNetwork]{searchNetwork()}}
function.
}
\examples{
# convert a UK postcode
convertPostcode("SW1A1AA")

\dontrun{
# use with `searchNetwork()`
palace <- convertPostcode("SW1A1AA")
searchNetwork(lat = palace$lat, lng = palace$lng, max_dist = 10)
}

}
\seealso{
The \code{PostcodesioR} package at
\url{https://github.com/ropensci/PostcodesioR/}
}
