% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{opencage_reverse}
\alias{opencage_reverse}
\title{Reverse geocoding}
\usage{
opencage_reverse(
  latitude,
  longitude,
  key = opencage_key(),
  bounds = NULL,
  countrycode = NULL,
  language = NULL,
  limit = 10,
  min_confidence = NULL,
  no_annotations = FALSE,
  no_dedupe = FALSE,
  no_record = FALSE,
  abbrv = FALSE,
  add_request = TRUE
)
}
\arguments{
\item{latitude}{Numeric vectors of latitude and longitude values.}

\item{longitude}{Numeric vectors of latitude and longitude values.}

\item{key}{Your OpenCage API key as a character vector of length one. By
default, \code{\link[=opencage_key]{opencage_key()}} will attempt to retrieve the key from the
environment variable \code{OPENCAGE_KEY}.}

\item{bounds}{Bounding box, ignored for reverse geocoding.}

\item{countrycode}{Country code, ignored for reverse geocoding.}

\item{language}{An \href{https://en.wikipedia.org/wiki/IETF_language_tag}{IETF BCP 47 language tag} (such as "es" for
Spanish or "pt-BR" for Brazilian Portuguese). OpenCage will attempt to
return results in that language. Alternatively you can specify the "native"
tag, in which case OpenCage will attempt to return the response in the
"official" language(s). In case the \code{language} parameter is set to \code{NULL}
(which is the default), the tag is not recognized, or OpenCage does not
have a record in that language, the results will be returned in English.}

\item{limit}{How many results should be returned (1-100), ignored for reverse
geocoding.}

\item{min_confidence}{Numeric vector of integer values between 0 and 10
indicating the precision of the returned result as defined by its
geographical extent, (i.e. by the extent of the result's bounding box). See
the \href{https://opencagedata.com/api#confidence}{API documentation} for
details. Only results with at least the requested confidence will be
returned. Default is \code{NULL}.}

\item{no_annotations}{Logical vector indicating whether additional
information about the result location should be returned. \code{TRUE} by
default, which means that the results will not contain annotations.}

\item{no_dedupe}{Logical vector (default \code{FALSE}), when \code{TRUE} the results
will not be deduplicated.}

\item{no_record}{Logical vector of length one (default \code{FALSE}), when \code{TRUE}
no log entry of the query is created, and the geocoding request is not
cached by OpenCage.}

\item{abbrv}{Logical vector (default \code{FALSE}), when \code{TRUE} addresses in the
\code{formatted} field of the results are abbreviated (e.g. "Main St." instead
of "Main Street").}

\item{add_request}{Logical vector (default \code{FALSE}) indicating whether the
request is returned again with the results. If the \code{return} value is a
\code{df_list}, the query text is added as a column to the results. \code{json_list}
results will contain all request parameters, including the API key used!
This is currently ignored by OpenCage if return value is \code{geojson_list}.}
}
\value{
A list with
\itemize{
\item results as a tibble with one line per result,
\item the number of results as an integer,
\item the timestamp as a POSIXct object,
\item rate_info tibble/data.frame with the maximal number of API calls  per
day for the used key, the number of remaining calls for the day and the time
at which the number of remaining calls will be reset.
}
}
\description{
\ifelse{html}{\figure{lifecycle-soft-deprecated.svg}{options: alt='Soft-deprecated lifecycle'}}{\strong{Soft-deprecated}}

Soft deprecated: use \code{oc_reverse} or \code{oc_reverse_df} for reverse geocoding.
}
\examples{
\dontshow{if (oc_key_present() && oc_api_ok()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

opencage_reverse(
  latitude = 0, longitude = 0,
  limit = 2
)
\dontshow{\}) # examplesIf}
}
