% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-piracy.R
\docType{data}
\name{piracy}
\alias{piracy}
\title{Piracy and PIPA/SOPA}
\format{
A data frame with 534 observations on the following 8 variables.
\describe{
\item{name}{Name of legislator.}
\item{party}{Party affiliation as democrat (\code{D}), Republican (\code{R}), or Independent (\code{I}).}
\item{state}{Two letter state abbreviation.}
\item{money_pro}{Amount of money in dollars contributed to the legislator's campaign in 2010 by groups generally thought to be supportive of PIPA/SOPA: movie and TV studios, record labels.}
\item{money_con}{Amount of money in dollars contributed to the legislator's campaign in 2010 by groups generally thought to be opposed to PIPA/SOPA: computer and internet companies.}
\item{years}{Number of years of service in Congress.}
\item{stance}{Degree of support for PIPA/SOPA with levels \code{Leaning No}, \code{No}, \code{Undecided}, \code{Unknown}, \code{Yes}}
\item{chamber}{Whether the legislator is a member of either the \code{house} or \code{senate}.}
}
}
\source{
\url{https://projects.propublica.org/sopa}
The list may be slightly out of date since many politician's perspectives on
the legislation were in flux at the time of data collection.
}
\usage{
piracy
}
\description{
This dataset contains observations on all 100 US Senators and 434 of the
325 US Congressional Representatives related to their support of anti-piracy
legislation that was introduced at the end of 2011.
}
\details{
The Stop Online Piracy Act (SOPA) and the Protect Intellectual Property Act
(PIPA) were two bills introduced in the US House of Representatives and the
US Senate, respectively, to curtail copyright infringement.  The bill was
controversial because there were concerns the bill limited free speech
rights.  ProPublica, the independent and non-profit news organization,
compiled this dataset to compare the stance of legislators towards the
bills with the amount of campaign funds that they received from groups
considered to be supportive of or in opposition to the legislation.

For more background on the legislation and the formulation of
\code{money_pro} and \code{money_con}, read the documentation on ProPublica,
linked below.
}
\examples{

library(dplyr)
library(ggplot2)

pipa <- filter(piracy, chamber == "senate")

pipa |>
  group_by(stance) |>
  summarise(money_pro_mean = mean(money_pro, na.rm = TRUE)) |>
  ggplot(aes(x = stance, y = money_pro_mean)) +
  geom_col() +
  labs(
    x = "Stance", y = "Average contribution, in $",
    title = "Average contribution to the legislator's campaign in 2010",
    subtitle = "by groups supportive of PIPA/SOPA (movie and TV studios, record labels)"
  )

ggplot(pipa, aes(x = stance, y = money_pro)) +
  geom_boxplot() +
  labs(
    x = "Stance", y = "Contribution, in $",
    title = "Contribution by groups supportive of PIPA/SOPA",
    subtitle = "Movie and TV studios, record labels"
  )

ggplot(pipa, aes(x = stance, y = money_con)) +
  geom_boxplot() +
  labs(
    x = "Stance", y = "Contribution, in $",
    title = "Contribution by groups opposed to PIPA/SOPA",
    subtitle = "Computer and internet companies"
  )

pipa |>
  filter(
    money_pro > 0,
    money_con > 0
  ) |>
  mutate(for_pipa = ifelse(stance == "yes", "yes", "no")) |>
  ggplot(aes(x = money_pro, y = money_con, color = for_pipa)) +
  geom_point() +
  scale_color_manual(values = c("gray", "red")) +
  scale_y_log10() +
  scale_x_log10() +
  labs(
    x = "Contribution by pro-PIPA groups",
    y = "Contribution by anti-PIPA groups",
    color = "For PIPA"
  )
}
\keyword{Congress}
\keyword{PIPA}
\keyword{SOPA}
\keyword{copyright}
\keyword{datasets}
\keyword{infringement}
\keyword{legislation}
