% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunOptions.R
\name{opts_run}
\alias{opts_run}
\alias{print.OpenMppRunOpts}
\title{Run Configuration Options}
\usage{
opts_run(
  SimulationCases = 5000,
  SubValues = 12,
  RunStamp = TimeStamp(),
  Opts = list(),
  ...
)

\method{print}{OpenMppRunOpts}(x, ...)
}
\arguments{
\item{SimulationCases}{Number of cases to simulate. Default is 5000.}

\item{SubValues}{Number of sub values. Default is 12.}

\item{RunStamp}{Run stamp. Default is generated based on the current time.}

\item{Opts}{Additional options to pass to the \code{Opts} list component.}

\item{...}{Any other run options.}

\item{x}{Object to print.}
}
\description{
Run Configuration Options
}
\details{
The default number of \code{SimulationCases} is low to enable rapid
iteration but should be increased when running a model where the results
are expected to be robust.
}
\examples{
opts <- opts_run()
print(opts)

}
