% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordering.R
\name{ordering}
\alias{ordering}
\alias{monotonicity}
\title{ordering}
\usage{
ordering(x, na.rm = TRUE)

monotonicity(x, na.rm = TRUE)
}
\arguments{
\item{x}{numeric vector}

\item{na.rm}{logical; whether to omit \code{NA} values. (Default: TRUE)}
}
\value{
integer;
\itemize{
\item \strong{2} : stictly increasing
\item \strong{1} : increasing / montonically increasing / non-decreasing
\item \strong{0} : non-ordered or constant
\item \strong{-1}: decreasing / monotonically decreasing / non-increasing
\item \strong{-2}: strictly decreasing
\item \strong{\code{NA}}:\code{contains only}NA\code{s all }na.rm\code{did not resolve all}NA`s
}
}
\description{
Determining the ordering (montonicity) of a vector
}
\details{
\code{monotonicty} determines the monotonicy (first derivative) of a numeric
vector as one of:
\itemize{
\item stictly increasing,
\item increasing / montonically increasing / non-decreasing,
\item decreasing / monotonically decreasing / non-increasing,
\item strictly decreasing, or
\item constant
}

ordering tests, e.g. \link{is_increasing} are more efficient at testing.

\code{monotonicity()} is an alias for \code{ordering}.
}
\examples{
  ordering( 1:3 )      # 2  
  ordering( c(1,1,3) ) # 1 
  ordering( c(1,0,1) ) # 0  "No ordering, does not apply constant"
  ordering( c(3,1,1) ) # -1
  ordering( 3:1 )      # -2
  
}
\references{
http://en.wikipedia.org/wiki/Monotonic_function
http://stackoverflow.com/questions/13093912/how-to-check-if-a-sequence-of-numbers-is-monotonically-increasing-or-decreasing
}
