% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ord-format.r
\name{format}
\alias{format}
\alias{format.tbl_ord}
\alias{print.tbl_ord}
\title{Format a tbl_ord for printing}
\usage{
\method{format}{tbl_ord}(
  x,
  width = NULL,
  ...,
  n = NULL,
  max_extra_cols = NULL,
  max_footer_lines = NULL
)

\method{print}{tbl_ord}(
  x,
  width = NULL,
  ...,
  n = NULL,
  max_extra_cols = NULL,
  max_footer_lines = NULL
)
}
\arguments{
\item{x}{A \link{tbl_ord}.}

\item{width}{Width of text output to generate. This defaults to \code{NULL}, which
means use the \code{width} \link[pillar:pillar_options]{option}.}

\item{...}{Additional arguments.}

\item{n}{Number(s) of rows to show from each matrix factor, handled as by
\code{\link[tibble:formatting]{tibble::format.tbl()}}. If length 1, will apply to both matrix factors.
To pass \code{NULL} to only one factor, be sure to pass as a list, e.g. \code{n = list(6, NULL)}.}

\item{max_extra_cols}{Number of extra columns to print abbreviated information for,
if the width is too small for the entire tibble. If \code{NULL},
the \code{max_extra_cols} \link[pillar:pillar_options]{option} is used.
The previously defined \code{n_extra} argument is soft-deprecated.}

\item{max_footer_lines}{Maximum number of footer lines. If \code{NULL},
the \code{max_footer_lines} \link[pillar:pillar_options]{option} is used.}
}
\value{
The \code{format()} method returns a vector of strings that are more
elegantly printed by the \code{print()} method, which itself returns the tbl_ord
invisibly.
}
\description{
These methods of \code{\link[base:format]{base::format()}} and \code{\link[base:print]{base::print()}} render a
(usually more) tidy readout of a \link{tbl_ord} that is consistent across all
original ordination classes.
}
\details{
The \code{format} and \code{print} methods for class 'tbl_ord' are adapted from those
for class '\link[tibble:tbl_df-class]{tbl_df}' and for class 'tbl_graph' from the
\strong{tidygraph} package.

\strong{Note:} The \code{format()} function is tedius but cannot be easily modularized
without invoking \link{recoverers}, \link{annotation}, and \link{augmentation} multiple
times, thereby significantly reducing performance.
}
\examples{
iris_pca <- ordinate(iris[1:4], prcomp)

# single value applies to both factors
print(iris_pca, n = 10)

# double values apply to factors in order
print(iris_pca, n = c(6, 2))

# use `list()` to pass `NULL` (for default) to only one factor
print(iris_pca, n = list(2, NULL))
print(iris_pca, n = list(NULL, 2))
}
