% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-projection.r
\name{stat_projection}
\alias{stat_projection}
\title{Project rows onto columns or vice-versa}
\usage{
stat_projection(
  mapping = NULL,
  data = NULL,
  geom = "segment",
  position = "identity",
  referent = NULL,
  ...,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use to display the data for this layer.
When using a \verb{stat_*()} function to construct a layer, the \code{geom} argument
can be used to override the default coupling between stats and geoms. The
\code{geom} argument accepts the following:
\itemize{
\item A \code{Geom} ggproto subclass, for example \code{GeomPoint}.
\item A string naming the geom. To give the geom as a string, strip the
function name of the \code{geom_} prefix. For example, to use \code{geom_point()},
give the geom as \code{"point"}.
\item For more information and other ways to specify the geom, see the
\link[ggplot2:layer_geoms]{layer geom} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{referent}{The reference data set; see Details.}

\item{...}{Additional arguments passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A ggproto \link[ggplot2:layer]{layer}.
}
\description{
Compute projections of vectors from one matrix factor onto those
of the other.
}
\details{
An ordination model of continuous data can be used to predict values
along one dimension from those along the other, using the artificial axes
as intermediaries. The predictions correspond geometrically to projections
of elements of one matrix factor in principal coordinates onto those of the
other factor in standard coordinates. In the most familiar setting of PCA
biplots, variable (column) values are predicted from case (row) locations
along PC1 and PC2. This transformation obtains the axis projections as
\verb{xend,yend} and pairs them with original points \verb{x,y} to demarcate segments
visualizing the projections.

\strong{WARNING:}
This layer is appropriate only with axes in standard coordinates (usually
\code{\link[=confer_inertia]{confer_inertia(p = "rows")}}) and predictive calibration
(\code{\link[=ggbiplot]{ggbiplot(axis.type = "predictive")}}).
}
\section{Referential stats}{

This statistical transformation is done with respect to reference data passed
to \code{referent} (ignored if \code{NULL}, the default, possibly resulting in empty
output). See \code{\link[gggda:stat_referent]{gggda::stat_referent()}} for more details. This relies on a
sleight of hand through a new undocumented \code{LayerRef} class and associated
\code{\link[ggplot2:ggplot_add]{ggplot2::ggplot_add()}} method. As a result, only layers constructed using
this \verb{stat_*()} shortcut will pass the necessary positional aesthetics to the
\verb{$setup_params()} step, making them available to pre-process \code{referent} data.

The biplot shortcuts automatically substitute the complementary matrix factor
for \code{referent = NULL} and will use an integer vector to select a subset from
this factor. These uses do not require the mapping passage.
}

\section{Biplot layers}{

\code{\link[=ggbiplot]{ggbiplot()}} uses \code{\link[ggplot2:fortify]{ggplot2::fortify()}} internally to produce a single data
frame with a \code{.matrix} column distinguishing the subjects (\code{"rows"}) and
variables (\code{"cols"}). The stat layers \code{stat_rows()} and \code{stat_cols()} simply
filter the data frame to one of these two.

The geom layers \verb{geom_rows_*()} and \verb{geom_cols_*()} call the corresponding
stat in order to render plot elements for the corresponding factor matrix.
\verb{geom_dims_*()} selects a default matrix based on common practice, e.g.
points for rows and arrows for columns.
}

\section{Ordination aesthetics}{

This statistical transformation is compatible with the convenience function
\code{\link[=ord_aes]{ord_aes()}}.

Some transformations (e.g. \code{\link[=stat_center]{stat_center()}}) commute with projection to the
lower (1 or 2)-dimensional biplot space. If they detect aesthetics of the
form \verb{..coord[0-9]+}, then \code{..coord1} and \code{..coord2} are converted to \code{x} and
\code{y} while any remaining are ignored.

Other transformations (e.g. \code{\link[=stat_spantree]{stat_spantree()}}) yield different results in a
lower-dimensional biplot when they are computed before versus after
projection. If the stat layer detects these aesthetics, then the
transformation is performed before projection, and the results in the first
two dimensions are returned as \code{x} and \code{y}.

A small number of transformations (\code{\link[=stat_rule]{stat_rule()}}) are incompatible with
ordination aesthetics but will accept \code{ord_aes()} without warning.
}

\section{Computed variables}{
 These are calculated during the statistical
transformation and can be accessed with \link[ggplot2:aes_eval]{delayed evaluation}.
\describe{
\item{\verb{xend,yend}}{projections onto (specified) vectors}
}
}

\examples{
# simplify the Motor Trends data to two predictors legible at aspect ratio 1
mtcars \%>\%
  transform(hp00 = hp/100) \%>\%
  subset(select = c(mpg, hp00, wt)) ->
  subcars
# compute the gradient of `mpg` against these two predictors
lm(mpg ~ hp00 + wt, subcars) \%>\%
  coefficients() \%>\%
  as.list() \%>\% as.data.frame() ->
  grad
# project the data onto the gradient axis (with a reversed gradient vector)
ggplot(subcars, aes(x = hp00, y = wt)) +
  coord_equal() +
  geom_point(shape = "circle open") +
  geom_vector(data = -grad) +
  stat_projection(referent = grad)
}
\concept{stat layers}
