% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osfr-package.R
\docType{package}
\name{osfr-package}
\alias{osfr}
\alias{osfr-package}
\title{osfr: R interface to OSF}
\description{
osfr provides a suite of functions for interacting with the Open Science
Framework (OSF; \url{https://osf.io/}).
}
\section{What is OSF?}{


OSF is a free and open source project management repository designed to
support researchers across their entire project lifecycle. The service
includes free cloud storage and file version history, providing a
centralized location for all your research materials that can be kept
private, shared with select collaborators, or made publicly available with
citable DOIs.

Most work on OSF is organized around \emph{\strong{projects}}. Projects can contain
\emph{files}, groups of files in \emph{directories}, and/or files in sub-projects
called \emph{\strong{components}}. Note there is no storage limit on the size of
projects but individual files must be < 5Gb.
}

\section{Resources}{

\itemize{
\item To learn more about OSF check out the helpful series of guides published by
the Center for Open Science: \url{https://help.osf.io}
\item See the vignette for an overview of osfr's features:
\code{vignette("getting_started", package = "osfr")}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://docs.ropensci.org/osfr/}
  \item \url{https://github.com/ropensci/osfr}
  \item Report bugs at \url{https://github.com/ropensci/osfr/issues}
}

}
\author{
\strong{Maintainer}: Aaron Wolen \email{aaron@wolen.com} (\href{https://orcid.org/0000-0003-2542-2202}{ORCID})

Authors:
\itemize{
  \item Chris Hartgerink \email{chjh@protonmail.com} (\href{https://orcid.org/0000-0003-1050-6809}{ORCID})
}

Other contributors:
\itemize{
  \item Timothy York \email{timothypyork@gmail.com} (\href{https://orcid.org/0000-0003-4068-4286}{ORCID}) [contributor]
  \item Ryan Hafen \email{rhafen@purdue.edu} [contributor]
  \item Brian Richards \email{brian.g.richards@gmail.com} [contributor]
  \item Courtney Soderberg \email{courtney@cos.io} (\href{https://orcid.org/0000-0003-1227-7042}{ORCID}) [contributor]
  \item Carl Boettiger \email{cboettig@gmail.com} (\href{https://orcid.org/0000-0002-1642-628X}{ORCID}) [reviewer]
  \item Heidi Seibold \email{heidi.seibold@stat.uni-muenchen.de} [reviewer]
}

}
