% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearest.R
\name{nearest}
\alias{nearest}
\title{nearest accessible position}
\usage{
nearest(lat, lng, api_version = 5, localhost = F, timeout = 0.001)
}
\arguments{
\item{lat, }{A numeric (-90 < lat < 90)}

\item{lng, }{A numeric (-180 < lng < 180)}

\item{api_version, }{A numeric (either 4 or 5)}

\item{localhost, }{A logical (TRUE = localhost is used, FALSE = onlinehost is used)}

\item{timeout}{A numeric indicating the timeout between server requests (in order to prevent queue overflows). Default is 0.001s.}
}
\value{
A data.frame with lat and lng
}
\description{
nearest() calculates the nearest position to the given coordinates which can be accessed by car.
The coordinate-standard is WGS84. Attention: The OSRM API v4 is only working locally, but
not with the 'OSRM' webserver.
}
\examples{
\dontrun{
osrmr::nearest(47,9, 5, FALSE)

Sys.setenv("OSRM_PATH_API_5"="C:/OSRM_API5")
osrmr::run_server(Sys.getenv("OSRM_PATH_API_5"), "switzerland-latest.osrm")
osrmr::nearest(47,9, 5, TRUE)
osrmr::quit_server()
Sys.unsetenv("OSRM_PATH_API_5")

Sys.setenv("OSRM_PATH_API_4"="C:/OSRM_API4")
osrmr::run_server(Sys.getenv("OSRM_PATH_API_4"), "switzerland-latest.osrm")
osrmr::nearest(47,9, 4, TRUE)
osrmr::quit_server()
Sys.unsetenv("OSRM_PATH_API_4")}
}
