% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{paddle_get_events}
\alias{paddle_get_events}
\title{Get Paddle Events}
\usage{
paddle_get_events(after = NULL, order_by = NULL, per_page = NULL)
}
\arguments{
\item{after}{Character. Return entities after the specified Paddle ID when working with paginated endpoints. Optional.}

\item{order_by}{Character. Optional. Must be in the form "id[ASC]" or "id[DESC]".}

\item{per_page}{Integer. Optional. Max 200, defaults to 50.}
}
\value{
A list of events returned by the Paddle API.
}
\description{
Retrieves a list of event entities from Paddle. You can optionally filter by event type.
}
\examples{
\dontshow{if (paddle_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_paddle_mode("sandbox")
result <- paddle_get_events(
  per_page = 2
)
\dontshow{\}) # examplesIf}
}
