% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_funcs.R
\name{format_interval}
\alias{format_interval}
\title{Make a period character vector}
\usage{
format_interval(
  x,
  start_format = "\%Y-\%m-\%d",
  end_format = start_format,
  sep = " ",
  end_offset = 0,
  units_to_last = NULL
)
}
\arguments{
\item{x}{A vector of class \code{Date}, \code{POSIXct} or \code{POSIXlt},
of which the values are unique.}

\item{start_format}{String to format the start values of each period, to be used
in \code{strftime}.}

\item{end_format}{String to format the end values of each period, to be used
in \code{strftime}.}

\item{sep}{Character string that separates the \code{start_format} and the
\code{end_format}.}

\item{end_offset}{Units in days if \code{x} is \code{Date}, or in seconds if
\code{x} is \code{POSIXct} or \code{POSIXlt}.
Will be subtracted from the end of each period.
If 0, the end of the previous period is equal to the start of the next.}

\item{units_to_last}{To determine the formatting of the last value in \code{x},
the length of the last period has to be specified. If \code{NULL} the
function guesses based on the interval of \code{x}.
Specify in days when \code{x} is \code{Date}, or in seconds when \code{x} is
\code{POSIXct} or \code{POSIXlt}.}
}
\value{
A character vector showing the interval.
}
\description{
After applying \code{thicken} all the observations of a period are mapped
to a single time point. This function will convert a datetime variable to
a character vector that reflects the period, instead of a single time point.
\code{strftime} is used to format the start and the end of the interval.
}
\details{
The end of the periods will be determined by the next unique value
in \code{x}. It does so without regarding the interval of \code{x}. If a specific
interval is desired, \code{thicken} and / or \code{pad} should first be
applied to create an equally spaced datetime variable.
}
\examples{
library(dplyr)
library(ggplot2)
plot_set <- emergency \%>\%
  head(500) \%>\%
  thicken("hour", "h") \%>\%
  count(h)

# this will show the data on the full hour
ggplot(plot_set, aes(h, n)) + geom_col()

# adding a character to indicate the hours of the interval.
plot_set \%>\%
  mutate(h_int = format_interval(h, "\%H", sep = "-"))
}
