% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpleModels.R
\name{sim.OU}
\alias{sim.OU}
\title{Simulate an Ornstein-Uhlenbeck time-series}
\usage{
sim.OU(
  ns = 20,
  anc = 0,
  theta = 10,
  alpha = 0.3,
  vstep = 0.1,
  vp = 1,
  nn = rep(20, ns),
  tt = 0:(ns - 1)
)
}
\arguments{
\item{ns}{number of populations in the sequence}

\item{anc}{ancestral phenotype}

\item{theta}{OU optimum (long-term mean)}

\item{alpha}{strength of attraction to the optimum}

\item{vstep}{step variance}

\item{vp}{phenotypic variance of each sample}

\item{nn}{vector of sample sizes}

\item{tt}{vector of sample times (ages)}
}
\value{
a \code{paleoTS} object
}
\description{
Simulate an Ornstein-Uhlenbeck time-series
}
\details{
This function simulates an Ornstein-Uhlenbeck (OU) process. In
  microevolutionary terms, this models a population ascending a nearby peak
  in the adaptive landscape. The optimal trait value is \code{theta},
  \code{alpha} indicates the strength of attraction to that peak (= strength
  of stabilizing selection around \code{theta}), \code{vstep} measures the
  random walk component (from genetic drift) and \code{anc} is the trait
  value at the start of the sequence.
}
\examples{
x1 <- sim.OU(alpha = 0.8)  # strong alpha
x2 <- sim.OU(alpha = 0.1)  # weaker alpha
plot(x1)
plot(x2, add = TRUE, col = "blue")

}
\references{
Hunt, G., M. A. Bell and M. P. Travis. 2008. Evolution toward a new adaptive
optimum: phenotypic evolution in a fossil stickleback lineage. \emph{Evolution} 62(3):
700-710.
}
\seealso{
\code{\link{opt.joint.OU}}
}
