% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpleModels.R
\name{sim.covTrack}
\alias{sim.covTrack}
\title{Simulate trait evolution that tracks a covariate}
\usage{
sim.covTrack(
  ns = 20,
  b = 1,
  evar = 0.1,
  z,
  nn = rep(20, times = ns),
  tt = 0:(ns - 1),
  vp = 1
)
}
\arguments{
\item{ns}{number of populations in a sequence}

\item{b}{slope of the relationship between the change in the covariate and
the change in the trait}

\item{evar}{residual variance of the same relationship}

\item{z}{vector of covariate that the trait tracks}

\item{nn}{vector of sample sizes for populations}

\item{tt}{vector of times (ages) for populations}

\item{vp}{phenotypic trait variance within each population}
}
\value{
a \code{paleoTS} object
}
\description{
Simulate trait evolution that tracks a covariate
}
\details{
In this model, changes in a trait are linearly related to changes in
  a covariate with a slope of \code{b} and residual variance \code{evar}:
  \code{dx = b * dz + eps}, where \code{eps ~ N(0, evar)}.  This model was
  described, and applied to an example in which body size changes tracked
  changes in temperature, by Hunt et al. (2010).
}
\note{
For a trait sequence of length \code{ns}, the covariate, \code{z}, can
  be of length \code{ns} - 1,in which case it is interpreted as the vector of
  \emph{changes}, \code{dz}. If \code{z} is of length \code{ns},
  differences are taken and these are used as the \code{dz}'s.
}
\examples{
set.seed(13)
z <- c(1, 2, 2, 4, 0, 8, 2, 3, 1, 9, 4, 3)
x <- sim.covTrack(ns = 12, z = z, b = 0.5, evar = 0.2)
plot(x, ylim = c(-1, 10))
lines(x$tt, z, col = "blue")
}
\references{
Hunt, G, S. Wicaksono, J. E. Brown, and K. G. Macleod. 2010.
Climate-driven body size trends in the ostracod fauna of the deep Indian
Ocean. \emph{Palaeontology} 53(6): 1255-1268.
}
