% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_change.R
\name{rate_change}
\alias{rate_change}
\title{rate_change}
\usage{
rate_change(
  obj,
  t,
  n = 3,
  type = "standard",
  params.x,
  params.t,
  copula,
  definition = "c/d",
  params.copula,
  params.ph,
  seed,
  cutoff = 100,
  newx
)
}
\arguments{
\item{obj}{A 'fitROC' or 'TimeROC' object.\cr}

\item{t}{A numeric/vector specifying the time of interest.\cr}

\item{n}{Number of point on the ROC curve which will be used to check the rate of change.\cr}

\item{type}{A string specifying the type of analysis used. (Default: 'standard')\cr}

\item{params.x}{A named vector for the biomarker's parameter.\cr}

\item{params.t}{A named vector for the time-to-event parameter.\cr}

\item{copula}{A string indicating the type of copula to be used.\cr}

\item{definition}{A string indicitaing the definition of ROC to use.\cr}

\item{params.copula}{A numeric for copula's parameter.\cr}

\item{params.ph}{A numeric for proportional hazard model's parameter.\cr}

\item{seed}{A numeric to pass in set.seed.\cr}

\item{cutoff}{A numeric to generate total biomarker used.\cr}

\item{newx}{A numeric.\cr}
}
\value{
A list of rate change dt, dx and the angle between these rate of change.
}
\description{
Function to compute the rate change of the ROC with respect to dx and dt.
}
\examples{
\dontrun{
## Using 'fitROC' object
test <- timeroc_obj("normal-weibull-copula", copula = "gaussian")
rr <- rtimeroc(test, n=500,
               params.x = c(mean=5, sd=0.8),
               params.t = c(shape=1.6, scale=5),
              params.copula = -0.3)
cc <- timeroc_fit(test, x = rr$x, t = rr$t, event = rr$event)
jj <- rate_change(cc, t = c(1,2,10,11))

## Using 'TimeROC' object
test <- timeroc_obj("normal-weibull-PH",
params.x = c(mean=5, sd=0.8),
params.t = c(shape=1.6, scale=5),
params.ph = 1)
ee <- rate_change(test, t = c(.1,.2))
}
}
