% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmd_check_template.R
\name{rmd_check_template}
\alias{rmd_check_template}
\title{Check an Rmd against a template}
\usage{
rmd_check_template(rmd, template, ...)
}
\arguments{
\item{rmd}{The rmd to be check, can be an \code{rmd_ast}, \code{rmd_tibble}, or text
that can be handled by \code{parse_rmd}.}

\item{template}{\code{rmd_template} object from \code{\link[=rmd_template]{rmd_template()}}.}

\item{...}{Unused, for extensibility.}
}
\value{
Invisibly returns \code{TRUE} if the rmd matches the template, \code{FALSE} otherwise.
}
\description{
This function compares the provided Rmd against a template and reports on
discrepancies (e.g. missing or unmodified components).
}
\examples{
tmpl = parse_rmd(system.file("examples/hw01.Rmd", package = "parsermd")) \%>\%
  rmd_select(by_section(c("Exercise *", "Solution"))) \%>\%
  rmd_template(keep_content = TRUE)

rmd_check_template(
  system.file("examples/hw01-student.Rmd", package = "parsermd"),
  tmpl
)

}
