% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmd_fenced_div_wrap.R
\name{rmd_fenced_div_wrap}
\alias{rmd_fenced_div_wrap}
\title{Wrap selected nodes with fenced divs}
\usage{
rmd_fenced_div_wrap(
  x,
  ...,
  open = rmd_fenced_div_open(),
  allow_multiple = FALSE
)
}
\arguments{
\item{x}{Rmd object, e.g. \code{rmd_ast} or \code{rmd_tibble}.}

\item{...}{One or more unquoted expressions separated by commas for node selection.
Uses the same syntax as \code{\link[=rmd_select]{rmd_select()}}.}

\item{open}{An \code{rmd_fenced_div_open} node that defines the opening fenced div.
Defaults to \code{rmd_fenced_div_open()}.}

\item{allow_multiple}{Logical. If \code{FALSE} (default), throws an error when
selected indices are discontinuous. If \code{TRUE}, allows wrapping multiple
discontinuous ranges separately.}
}
\value{
Returns the modified Rmd object with selected nodes wrapped in the fenced div(s).
}
\description{
This function wraps selected nodes in an \code{rmd_ast} with fenced div
opening and closing tags. The selection is implemented using the same approach
as \code{\link[=rmd_select]{rmd_select()}} which enables a variety of useful syntax for selecting nodes.

The function checks if the selected indices form a single continuous range. If this
is not the case then an error will be thrown. If wrapping multiple discontinous ranges
of nodes is desired then the \code{allow_multiple} can be set to \code{TRUE}.
}
\examples{
rmd = parse_rmd(system.file("examples/hw01.Rmd", package = "parsermd"))

rmd_fenced_div_wrap(rmd, "plot-dino":"cor-dino")

rmd_fenced_div_wrap(rmd, has_type("rmd_chunk"), allow_multiple=TRUE)

rmd_fenced_div_wrap(
  rmd, has_type("rmd_chunk"),
  open = rmd_fenced_div_open(classes = ".note"),
  allow_multiple = TRUE
)

}
