% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\name{baulieu1}
\alias{baulieu1}
\alias{baulieu1,Partition,Partition-method}
\alias{baulieu1,PairCoefficients,missing-method}
\title{Baulieu Index 1}
\usage{
baulieu1(p, q)

\S4method{baulieu1}{Partition,Partition}(p, q)

\S4method{baulieu1}{PairCoefficients,missing}(p, q = NULL)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute the index 1 of Baulieu
\deqn{\frac{ N^2 - N(N_{10} + N_{01}) + (N_{10} - N_{01})^2 }{ N^2 }}
}
\section{Methods (by class)}{
\itemize{
\item \code{baulieu1(p = Partition, q = Partition)}: Compute given two partitions

\item \code{baulieu1(p = PairCoefficients, q = missing)}: Compute given the pair coefficients

}}
\examples{
isTRUE(all.equal(baulieu1(new("Partition", c(0, 0, 0, 1, 1)), 
                          new("Partition", c(0, 0, 1, 1, 1))), 0.76))

}
\references{
\insertRef{Baulieu1989}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
