% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_functions.R
\name{import_batch}
\alias{import_batch}
\title{Batch import of files for either Motive or Flydra (but not a mix of both)}
\usage{
import_batch(
  file_path_list,
  import_method = c("flydra", "motive"),
  file_id = NA,
  subject_name = NULL,
  frame_rate = NULL,
  simplify_marker_naming = TRUE,
  import_messaging = FALSE,
  ...
)
}
\arguments{
\item{file_path_list}{A list of file paths}

\item{import_method}{Either "flydra" or "motive"}

\item{file_id}{Optional}

\item{subject_name}{For Flydra, the assigned subject name}

\item{frame_rate}{For Flydra, the assigned frame rate}

\item{simplify_marker_naming}{default TRUE; for Motive, whether marker naming
should be simplified}

\item{import_messaging}{default FALSE; should this function report each time
a file has been imported?}

\item{...}{Additional arguments (may remove this if needed)}
}
\value{
A list of viewr objects (tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}).
}
\description{
Batch import of files for either Motive or Flydra (but not a mix of both)
}
\details{
Refer to \code{read_motive_csv()} and \code{read_flydra_mat()} for
details of data import methods.
}
\examples{
## Since we only have one example file of each type provided
## in pathviewr, we will simply import the same example multiple
## times to simulate batch importing. Replace the contents of
## the following list with your own list of files to be imported.

## Make a list of the same example file 3x
import_list <-
  c(rep(
    system.file("extdata", "pathviewr_motive_example_data.csv",
                package = 'pathviewr'),
    3
  ))

## Batch import
motive_batch_imports <-
  import_batch(import_list,
               import_method = "motive",
               import_messaging = TRUE)

## Batch cleaning of these imported files
## via clean_viewr_batch()
motive_batch_cleaned <-
  clean_viewr_batch(
    file_announce = TRUE,
    motive_batch_imports,
    desired_percent = 50,
    max_frame_gap = "autodetect",
    span = 0.95
  )

## Alternatively, use import_and_clean_batch() to
## combine import with cleaning on a batch of files
motive_batch_import_and_clean <-
  import_and_clean_batch(
    import_list,
    import_method = "motive",
    import_messaging = TRUE,
    motive_batch_imports,
    desired_percent = 50,
    max_frame_gap = "autodetect",
    span = 0.95
  )

## Each of these lists of objects can be bound into
## one viewr object (i.e. one tibble) via
## bind_viewr_objects()
motive_bound_one <-
  bind_viewr_objects(motive_batch_cleaned)

motive_bound_two <-
  bind_viewr_objects(motive_batch_import_and_clean)

## Either route results in the same object ultimately:
identical(motive_bound_one, motive_bound_two)
}
\seealso{
Other data import functions: 
\code{\link{as_viewr}()},
\code{\link{import_and_clean_batch}()},
\code{\link{read_flydra_mat}()},
\code{\link{read_motive_csv}()}

Other batch functions: 
\code{\link{bind_viewr_objects}()},
\code{\link{clean_viewr_batch}()},
\code{\link{import_and_clean_batch}()}
}
\author{
Vikram B. Baliga
}
\concept{batch functions}
\concept{data import functions}
