% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.rspec.R
\name{merge.rspec}
\alias{merge.rspec}
\title{Merge two rspec objects}
\usage{
\method{merge}{rspec}(x, y, ...)
}
\arguments{
\item{x, y}{(required) \code{rspec} objects to merge.}

\item{...}{additional class arguments.}
}
\value{
an object of class \code{rspec} for use with \code{pavo} functions.
Will use \code{by = "wl"} if unspecified, or automatically append \code{wl} to the
\code{by} argument if one is specified.
}
\description{
Merges two \code{rspec} objects into a single \code{rspec} object.
}
\examples{

# Load angle-resolved reflectance data for a green-winged teal, and
# split it in two
data(teal)
teal1 <- teal[, c(1, 2:5)]
teal2 <- teal[, c(1, 6:13)]

# Merge the two split datasets back into one, with a shared 'wl' column
teal.mer <- merge(teal1, teal2, by = "wl")

# Examine the results, and compare the original to the (identical)
# reconstructed version
plot(teal.mer)
plot(teal)
identical(teal.mer, teal)

# Or an equivalent method, which also allows for the merging of more than one rspec
# object at a time (simply add further objects to the list())
teal.mer2 <- do.call(merge, list(teal1, teal2))

# Check equivalence
identical(teal.mer2, teal)

}
\seealso{
\code{\link[=as.rspec]{as.rspec()}}, \code{\link[=aggspec]{aggspec()}}
}
\author{
Chad Eliason \email{cme16@zips.uakron.edu}
}
