% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resourceexplorer_operations.R
\name{resourceexplorer_list_resources}
\alias{resourceexplorer_list_resources}
\title{Returns a list of resources and their details that match the specified
criteria}
\usage{
resourceexplorer_list_resources(
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  ViewArn = NULL
)
}
\arguments{
\item{Filters}{}

\item{MaxResults}{The maximum number of results that you want included on each page of the
response. If you do not include this parameter, it defaults to a value
appropriate to the operation. If additional items exist beyond those
included in the current response, the \code{NextToken} response element is
present and has a value (is not null). Include that value as the
\code{NextToken} request parameter in the next call to the operation to get
the next part of the results.

An API operation can return fewer results than the maximum even when
there are more results available. You should check \code{NextToken} after
every operation to ensure that you receive all of the results.}

\item{NextToken}{The parameter for receiving additional results if you receive a
\code{NextToken} response in a previous request. A \code{NextToken} response
indicates that more output is available. Set this parameter to the value
of the previous call's \code{NextToken} response to indicate where the output
should continue from. The pagination tokens expire after 24 hours.}

\item{ViewArn}{Specifies the Amazon resource name (ARN) of the view to use for the
query. If you don't specify a value for this parameter, then the
operation automatically uses the default view for the Amazon Web
Services Region in which you called this operation. If the Region either
doesn't have a default view or if you don't have permission to use the
default view, then the operation fails with a 401 Unauthorized
exception.}
}
\description{
Returns a list of resources and their details that match the specified criteria. This query must use a view. If you don’t explicitly specify a view, then Resource Explorer uses the default view for the Amazon Web Services Region in which you call this operation.

See \url{https://www.paws-r-sdk.com/docs/resourceexplorer_list_resources/} for full documentation.
}
\keyword{internal}
