% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/billingconductor_operations.R
\name{billingconductor_list_account_associations}
\alias{billingconductor_list_account_associations}
\title{This is a paginated call to list linked accounts that are linked to the
payer account for the specified time period}
\usage{
billingconductor_list_account_associations(
  BillingPeriod = NULL,
  Filters = NULL,
  NextToken = NULL
)
}
\arguments{
\item{BillingPeriod}{The preferred billing period to get account associations.}

\item{Filters}{The filter on the account ID of the linked account, or any of the
following:

\code{MONITORED}: linked accounts that are associated to billing groups.

\code{UNMONITORED}: linked accounts that aren't associated to billing groups.

\verb{Billing Group Arn}: linked accounts that are associated to the provided
billing group Arn.}

\item{NextToken}{The pagination token that's used on subsequent calls to retrieve
accounts.}
}
\description{
This is a paginated call to list linked accounts that are linked to the payer account for the specified time period. If no information is provided, the current billing period is used. The response will optionally include the billing group that's associated with the linked account.

See \url{https://www.paws-r-sdk.com/docs/billingconductor_list_account_associations/} for full documentation.
}
\keyword{internal}
