% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_create_persistent_contact_association}
\alias{connect_create_persistent_contact_association}
\title{Enables rehydration of chats for the lifespan of a contact}
\usage{
connect_create_persistent_contact_association(
  InstanceId,
  InitialContactId,
  RehydrationType,
  SourceContactId,
  ClientToken = NULL
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can \href{https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html}{find the instance ID}
in the Amazon Resource Name (ARN) of the instance.}

\item{InitialContactId}{[required] This is the contactId of the current contact that the
\code{\link[=connect_create_persistent_contact_association]{create_persistent_contact_association}}
API is being called from.}

\item{RehydrationType}{[required] The contactId chosen for rehydration depends on the type chosen.
\itemize{
\item \code{ENTIRE_PAST_SESSION}: Rehydrates a chat from the most recently
terminated past chat contact of the specified past ended chat
session. To use this type, provide the \code{initialContactId} of the
past ended chat session in the \code{sourceContactId} field. In this
type, Amazon Connect determines what the most recent chat contact on
the past ended chat session and uses it to start a persistent chat.
\item \code{FROM_SEGMENT}: Rehydrates a chat from the specified past chat
contact provided in the \code{sourceContactId} field.
}

The actual contactId used for rehydration is provided in the response of
this API.

To illustrate how to use rehydration type, consider the following
example: A customer starts a chat session. Agent a1 accepts the chat and
a conversation starts between the customer and Agent a1. This first
contact creates a contact ID \strong{C1}. Agent a1 then transfers the chat to
Agent a2. This creates another contact ID \strong{C2}. At this point Agent a2
ends the chat. The customer is forwarded to the disconnect flow for a
post chat survey that creates another contact ID \strong{C3}. After the chat
survey, the chat session ends. Later, the customer returns and wants to
resume their past chat session. At this point, the customer can have
following use cases:
\itemize{
\item \strong{Use Case 1}: The customer wants to continue the past chat session
but they want to hide the post chat survey. For this they will use
the following configuration:
\itemize{
\item \strong{Configuration}
\itemize{
\item SourceContactId = "C2"
\item RehydrationType = "FROM_SEGMENT"
}
\item \strong{Expected behavior}
\itemize{
\item This starts a persistent chat session from the specified
past ended contact (C2). Transcripts of past chat sessions
C2 and C1 are accessible in the current persistent chat
session. Note that chat segment C3 is dropped from the
persistent chat session.
}
}
\item \strong{Use Case 2}: The customer wants to continue the past chat session
and see the transcript of the entire past engagement, including the
post chat survey. For this they will use the following
configuration:
\itemize{
\item \strong{Configuration}
\itemize{
\item SourceContactId = "C1"
\item RehydrationType = "ENTIRE_PAST_SESSION"
}
\item \strong{Expected behavior}
\itemize{
\item This starts a persistent chat session from the most recently
ended chat contact (C3). Transcripts of past chat sessions
C3, C2 and C1 are accessible in the current persistent chat
session.
}
}
}}

\item{SourceContactId}{[required] The contactId from which a persistent chat session must be started.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.}
}
\description{
Enables rehydration of chats for the lifespan of a contact. For more information about chat rehydration, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html}{Enable persistent chat} in the \emph{Amazon Connect Administrator Guide}.

See \url{https://www.paws-r-sdk.com/docs/connect_create_persistent_contact_association/} for full documentation.
}
\keyword{internal}
