% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_dismiss_user_contact}
\alias{connect_dismiss_user_contact}
\title{Dismisses contacts from an agent’s CCP and returns the agent to an
available state, which allows the agent to receive a new routed contact}
\usage{
connect_dismiss_user_contact(UserId, InstanceId, ContactId)
}
\arguments{
\item{UserId}{[required] The identifier of the user account.}

\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can find the
instanceId in the ARN of the instance.}

\item{ContactId}{[required] The identifier of the contact.}
}
\description{
Dismisses contacts from an agent’s CCP and returns the agent to an available state, which allows the agent to receive a new routed contact. Contacts can only be dismissed if they are in a \code{MISSED}, \code{ERROR}, \code{ENDED}, or \code{REJECTED} state in the \href{https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html}{Agent Event Stream}.

See \url{https://www.paws-r-sdk.com/docs/connect_dismiss_user_contact/} for full documentation.
}
\keyword{internal}
