% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workdocs_operations.R
\name{workdocs_get_document_path}
\alias{workdocs_get_document_path}
\title{Retrieves the path information (the hierarchy from the root folder) for
the requested document}
\usage{
workdocs_get_document_path(
  AuthenticationToken = NULL,
  DocumentId,
  Limit = NULL,
  Fields = NULL,
  Marker = NULL
)
}
\arguments{
\item{AuthenticationToken}{Amazon WorkDocs authentication token. Not required when using Amazon Web
Services administrator credentials to access the API.}

\item{DocumentId}{[required] The ID of the document.}

\item{Limit}{The maximum number of levels in the hierarchy to return.}

\item{Fields}{A comma-separated list of values. Specify \code{NAME} to include the names of
the parent folders.}

\item{Marker}{This value is not supported.}
}
\description{
Retrieves the path information (the hierarchy from the root folder) for the requested document.

See \url{https://www.paws-r-sdk.com/docs/workdocs_get_document_path/} for full documentation.
}
\keyword{internal}
