% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workmail_operations.R
\name{workmail_register_mail_domain}
\alias{workmail_register_mail_domain}
\title{Registers a new domain in WorkMail and SES, and configures it for use by
WorkMail}
\usage{
workmail_register_mail_domain(ClientToken = NULL, OrganizationId, DomainName)
}
\arguments{
\item{ClientToken}{Idempotency token used when retrying requests.}

\item{OrganizationId}{[required] The WorkMail organization under which you're creating the domain.}

\item{DomainName}{[required] The name of the mail domain to create in WorkMail and SES.}
}
\description{
Registers a new domain in WorkMail and SES, and configures it for use by WorkMail. Emails received by SES for this domain are routed to the specified WorkMail organization, and WorkMail has permanent permission to use the specified domain for sending your users' emails.

See \url{https://www.paws-r-sdk.com/docs/workmail_register_mail_domain/} for full documentation.
}
\keyword{internal}
