% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanroomsml_operations.R
\name{cleanroomsml_create_configured_model_algorithm}
\alias{cleanroomsml_create_configured_model_algorithm}
\title{Creates a configured model algorithm using a container image stored in
an ECR repository}
\usage{
cleanroomsml_create_configured_model_algorithm(
  name,
  description = NULL,
  roleArn,
  trainingContainerConfig = NULL,
  inferenceContainerConfig = NULL,
  tags = NULL,
  kmsKeyArn = NULL
)
}
\arguments{
\item{name}{[required] The name of the configured model algorithm.}

\item{description}{The description of the configured model algorithm.}

\item{roleArn}{[required] The Amazon Resource Name (ARN) of the role that is used to access the
repository.}

\item{trainingContainerConfig}{Configuration information for the training container, including
entrypoints and arguments.}

\item{inferenceContainerConfig}{Configuration information for the inference container that is used when
you run an inference job on a configured model algorithm.}

\item{tags}{The optional metadata that you apply to the resource to help you
categorize and organize them. Each tag consists of a key and an optional
value, both of which you define.

The following basic restrictions apply to tags:
\itemize{
\item Maximum number of tags per resource - 50.
\item For each resource, each tag key must be unique, and each tag key can
have only one value.
\item Maximum key length - 128 Unicode characters in UTF-8.
\item Maximum value length - 256 Unicode characters in UTF-8.
\item If your tagging schema is used across multiple services and
resources, remember that other services may have restrictions on
allowed characters. Generally allowed characters are: letters,
numbers, and spaces representable in UTF-8, and the following
characters: + - = . _ : / @.
\item Tag keys and values are case sensitive.
\item Do not use aws:, AWS:, or any upper or lowercase combination of such
as a prefix for keys as it is reserved for AWS use. You cannot edit
or delete tag keys with this prefix. Values can have this prefix. If
a tag value has aws as its prefix but the key does not, then Clean
Rooms ML considers it to be a user tag and will count against the
limit of 50 tags. Tags with only the key prefix of aws do not count
against your tags per resource limit.
}}

\item{kmsKeyArn}{The Amazon Resource Name (ARN) of the KMS key. This key is used to
encrypt and decrypt customer-owned data in the configured ML model
algorithm and associated data.}
}
\description{
Creates a configured model algorithm using a container image stored in an ECR repository.

See \url{https://www.paws-r-sdk.com/docs/cleanroomsml_create_configured_model_algorithm/} for full documentation.
}
\keyword{internal}
