% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detective_operations.R
\name{detective_list_investigations}
\alias{detective_list_investigations}
\title{Detective investigations lets you investigate IAM users and IAM roles
using indicators of compromise}
\usage{
detective_list_investigations(
  GraphArn,
  NextToken = NULL,
  MaxResults = NULL,
  FilterCriteria = NULL,
  SortCriteria = NULL
)
}
\arguments{
\item{GraphArn}{[required] The Amazon Resource Name (ARN) of the behavior graph.}

\item{NextToken}{Lists if there are more results available. The value of nextToken is a
unique pagination token for each page. Repeat the call using the
returned token to retrieve the next page. Keep all other arguments
unchanged.

Each pagination token expires after 24 hours. Using an expired
pagination token will return a Validation Exception error.}

\item{MaxResults}{Lists the maximum number of investigations in a page.}

\item{FilterCriteria}{Filters the investigation results based on a criteria.}

\item{SortCriteria}{Sorts the investigation results based on a criteria.}
}
\description{
Detective investigations lets you investigate IAM users and IAM roles using indicators of compromise. An indicator of compromise (IOC) is an artifact observed in or on a network, system, or environment that can (with a high level of confidence) identify malicious activity or a security incident. \code{\link[=detective_list_investigations]{list_investigations}} lists all active Detective investigations.

See \url{https://www.paws-r-sdk.com/docs/detective_list_investigations/} for full documentation.
}
\keyword{internal}
