% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fms_operations.R
\name{fms_put_admin_account}
\alias{fms_put_admin_account}
\title{Creates or updates an Firewall Manager administrator account}
\usage{
fms_put_admin_account(AdminAccount, AdminScope = NULL)
}
\arguments{
\item{AdminAccount}{[required] The Amazon Web Services account ID to add as an Firewall Manager
administrator account. The account must be a member of the organization
that was onboarded to Firewall Manager by
\code{\link[=fms_associate_admin_account]{associate_admin_account}}. For more
information about Organizations, see \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts.html}{Managing the Amazon Web Services Accounts in Your Organization}.}

\item{AdminScope}{Configures the resources that the specified Firewall Manager
administrator can manage. As a best practice, set the administrative
scope according to the principles of least privilege. Only grant the
administrator the specific resources or permissions that they need to
perform the duties of their role.}
}
\description{
Creates or updates an Firewall Manager administrator account. The account must be a member of the organization that was onboarded to Firewall Manager by \code{\link[=fms_associate_admin_account]{associate_admin_account}}. Only the organization's management account can create an Firewall Manager administrator account. When you create an Firewall Manager administrator account, the service checks to see if the account is already a delegated administrator within Organizations. If the account isn't a delegated administrator, Firewall Manager calls Organizations to delegate the account within Organizations. For more information about administrator accounts within Organizations, see \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts.html}{Managing the Amazon Web Services Accounts in Your Organization}.

See \url{https://www.paws-r-sdk.com/docs/fms_put_admin_account/} for full documentation.
}
\keyword{internal}
