% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_describe_malware_scans}
\alias{guardduty_describe_malware_scans}
\title{Returns a list of malware scans}
\usage{
guardduty_describe_malware_scans(
  DetectorId,
  NextToken = NULL,
  MaxResults = NULL,
  FilterCriteria = NULL,
  SortCriteria = NULL
)
}
\arguments{
\item{DetectorId}{[required] The unique ID of the detector that the request is associated with.

To find the \code{detectorId} in the current Region, see the Settings page in
the GuardDuty console, or run the
\code{\link[=guardduty_list_detectors]{list_detectors}} API.}

\item{NextToken}{You can use this parameter when paginating results. Set the value of
this parameter to null on your first call to the list action. For
subsequent calls to the action, fill nextToken in the request with the
value of NextToken from the previous response to continue listing data.}

\item{MaxResults}{You can use this parameter to indicate the maximum number of items that
you want in the response. The default value is 50. The maximum value is
50.}

\item{FilterCriteria}{Represents the criteria to be used in the filter for describing scan
entries.}

\item{SortCriteria}{Represents the criteria used for sorting scan entries. The
\href{https://docs.aws.amazon.com/guardduty/latest/APIReference/API_SortCriteria.html#guardduty-Type-SortCriteria-attributeName}{\code{attributeName}}
is required and it must be \code{scanStartTime}.}
}
\description{
Returns a list of malware scans. Each member account can view the malware scans for their own accounts. An administrator can view the malware scans for all the member accounts.

See \url{https://www.paws-r-sdk.com/docs/guardduty_describe_malware_scans/} for full documentation.
}
\keyword{internal}
