% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/macie2_operations.R
\name{macie2_create_invitations}
\alias{macie2_create_invitations}
\title{Sends an Amazon Macie membership invitation to one or more accounts}
\usage{
macie2_create_invitations(
  accountIds,
  disableEmailNotification = NULL,
  message = NULL
)
}
\arguments{
\item{accountIds}{[required] An array that lists Amazon Web Services account IDs, one for each
account to send the invitation to.}

\item{disableEmailNotification}{Specifies whether to send the invitation as an email message. If this
value is false, Amazon Macie sends the invitation (as an email message)
to the email address that you specified for the recipient's account when
you associated the account with your account. The default value is
false.}

\item{message}{Custom text to include in the email message that contains the
invitation. The text can contain as many as 80 alphanumeric characters.}
}
\description{
Sends an Amazon Macie membership invitation to one or more accounts.

See \url{https://www.paws-r-sdk.com/docs/macie2_create_invitations/} for full documentation.
}
\keyword{internal}
