% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/macie2_operations.R
\name{macie2_update_findings_filter}
\alias{macie2_update_findings_filter}
\title{Updates the criteria and other settings for a findings filter}
\usage{
macie2_update_findings_filter(
  action = NULL,
  clientToken = NULL,
  description = NULL,
  findingCriteria = NULL,
  id,
  name = NULL,
  position = NULL
)
}
\arguments{
\item{action}{The action to perform on findings that match the filter criteria
(findingCriteria). Valid values are: ARCHIVE, suppress (automatically
archive) the findings; and, NOOP, don't perform any action on the
findings.}

\item{clientToken}{A unique, case-sensitive token that you provide to ensure the
idempotency of the request.}

\item{description}{A custom description of the filter. The description can contain as many
as 512 characters.

We strongly recommend that you avoid including any sensitive data in the
description of a filter. Other users of your account might be able to
see this description, depending on the actions that they're allowed to
perform in Amazon Macie.}

\item{findingCriteria}{The criteria to use to filter findings.}

\item{id}{[required] The unique identifier for the Amazon Macie resource that the request
applies to.}

\item{name}{A custom name for the filter. The name must contain at least 3
characters and can contain as many as 64 characters.

We strongly recommend that you avoid including any sensitive data in the
name of a filter. Other users of your account might be able to see this
name, depending on the actions that they're allowed to perform in Amazon
Macie.}

\item{position}{The position of the filter in the list of saved filters on the Amazon
Macie console. This value also determines the order in which the filter
is applied to findings, relative to other filters that are also applied
to the findings.}
}
\description{
Updates the criteria and other settings for a findings filter.

See \url{https://www.paws-r-sdk.com/docs/macie2_update_findings_filter/} for full documentation.
}
\keyword{internal}
