% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_list_access_grants_instances}
\alias{s3control_list_access_grants_instances}
\title{Returns a list of S3 Access Grants instances}
\usage{
s3control_list_access_grants_instances(
  AccountId,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{AccountId}{[required] The Amazon Web Services account ID of the S3 Access Grants instance.}

\item{NextToken}{A pagination token to request the next page of results. Pass this value
into a subsequent \verb{List Access Grants Instances} request in order to
retrieve the next page of results.}

\item{MaxResults}{The maximum number of access grants that you would like returned in the
\verb{List Access Grants} response. If the results include the pagination
token \code{NextToken}, make another call using the \code{NextToken} to determine
if there are more results.}
}
\description{
Returns a list of S3 Access Grants instances. An S3 Access Grants instance serves as a logical grouping for your individual access grants. You can only have one S3 Access Grants instance per Region per account.

See \url{https://www.paws-r-sdk.com/docs/s3control_list_access_grants_instances/} for full documentation.
}
\keyword{internal}
