% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{codegurureviewer}
\alias{codegurureviewer}
\title{Amazon CodeGuru Reviewer}
\usage{
codegurureviewer(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
This section provides documentation for the Amazon CodeGuru Reviewer API
operations. CodeGuru Reviewer is a service that uses program analysis
and machine learning to detect potential defects that are difficult for
developers to find and recommends fixes in your Java and Python code.

By proactively detecting and providing recommendations for addressing
code defects and implementing best practices, CodeGuru Reviewer improves
the overall quality and maintainability of your code base during the
code review stage. For more information about CodeGuru Reviewer, see the
\emph{\href{https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/welcome.html}{AmazonCodeGuru Reviewer User Guide}.}

To improve the security of your CodeGuru Reviewer API calls, you can
establish a private connection between your VPC and CodeGuru Reviewer by
creating an \emph{interface VPC endpoint}. For more information, see
\href{https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/vpc-interface-endpoints.html}{CodeGuru Reviewer and interface VPC endpoints (Amazon Web Services PrivateLink)}
in the \emph{Amazon CodeGuru Reviewer User Guide}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- codegurureviewer(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.developer.tools:codegurureviewer_associate_repository]{associate_repository} \tab Use to associate an Amazon Web Services CodeCommit repository or a repository managed by Amazon Web Services CodeStar Connections with Amazon CodeGuru Reviewer\cr
\link[paws.developer.tools:codegurureviewer_create_code_review]{create_code_review} \tab Use to create a code review with a CodeReviewType of RepositoryAnalysis\cr
\link[paws.developer.tools:codegurureviewer_describe_code_review]{describe_code_review} \tab Returns the metadata associated with the code review along with its status\cr
\link[paws.developer.tools:codegurureviewer_describe_recommendation_feedback]{describe_recommendation_feedback} \tab Describes the customer feedback for a CodeGuru Reviewer recommendation\cr
\link[paws.developer.tools:codegurureviewer_describe_repository_association]{describe_repository_association} \tab Returns a RepositoryAssociation object that contains information about the requested repository association\cr
\link[paws.developer.tools:codegurureviewer_disassociate_repository]{disassociate_repository} \tab Removes the association between Amazon CodeGuru Reviewer and a repository\cr
\link[paws.developer.tools:codegurureviewer_list_code_reviews]{list_code_reviews} \tab Lists all the code reviews that the customer has created in the past 90 days\cr
\link[paws.developer.tools:codegurureviewer_list_recommendation_feedback]{list_recommendation_feedback} \tab Returns a list of RecommendationFeedbackSummary objects that contain customer recommendation feedback for all CodeGuru Reviewer users\cr
\link[paws.developer.tools:codegurureviewer_list_recommendations]{list_recommendations} \tab Returns the list of all recommendations for a completed code review\cr
\link[paws.developer.tools:codegurureviewer_list_repository_associations]{list_repository_associations} \tab Returns a list of RepositoryAssociationSummary objects that contain summary information about a repository association\cr
\link[paws.developer.tools:codegurureviewer_list_tags_for_resource]{list_tags_for_resource} \tab Returns the list of tags associated with an associated repository resource\cr
\link[paws.developer.tools:codegurureviewer_put_recommendation_feedback]{put_recommendation_feedback} \tab Stores customer feedback for a CodeGuru Reviewer recommendation\cr
\link[paws.developer.tools:codegurureviewer_tag_resource]{tag_resource} \tab Adds one or more tags to an associated repository\cr
\link[paws.developer.tools:codegurureviewer_untag_resource]{untag_resource} \tab Removes a tag from an associated repository
}
}

\examples{
\dontrun{
svc <- codegurureviewer()
svc$associate_repository(
  Foo = 123
)
}

}
