% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{cmp_probs}
\alias{cmp_probs}
\title{Item response function for pairwise comparisons}
\usage{
cmp_probs(alpha, scale, pa1, pa2, thRaw)
}
\arguments{
\item{alpha}{discrimination parameter}

\item{scale}{scale correction factor}

\item{pa1}{first latent worth}

\item{pa2}{second latent worth}

\item{thRaw}{vector of positive thresholds}
}
\value{
A vector of probabilities of observing each outcome
}
\description{
Use \code{\link{itemModelExplorer}} to explore the item model. In
this \pkg{shiny} app, the \emph{discrimination} parameter does what
is customary in item response models. However, it is not difficult
to show that discrimination is a function of thresholds and
scale. That is, discrimination is not an independent parameter.  In
paired comparison models, discrimination and measurement error are
confounded.
}
\details{
The thresholds are parameterized as the difference
from the previous threshold. For example, thresholds c(0.5, 0.6)
are not at the same location but are at locations c(0.5,
1.1). Thresholds are symmetric. If there is one threshold then the
model admits three possible response outcomes (e.g. \emph{win}, \emph{tie}, and
\emph{lose}). Responses are always stored centered with zero representing
a tie. Therefore, it is necessary to add one plus the number of
thresholds to response data to index into the vector returned by
\code{cmp_probs}. For example, if our response data is (-1, 0, 1)
and has one threshold then we would add 2 (1 + 1 threshold) to
obtain the indices (1, 2, 3).
}
\section{Math}{

Up until version 1.4, the item response model was based on the
partial credit model (Masters, 1982). In version 1.5,
the graded response model is used instead (Samejima, 1969).
The advantage of the graded response model is greater
independence among threshold parameters and the ability to
compute only the parts of the model that are actually needed
given particular observations. The curves predicted by both
models are similar and should obtain similar results in data
analyses.
}

\examples{
# Returns probabilities of
# c(pa1 > pa2, pa1 = pa2, pa1 < pa2)
cmp_probs(1,1,0,1,.8)

# Add another threshold for a symmtric 3 point Likert scale
cmp_probs(1,1,0,.5,c(.8, 1.6))
}
\references{
Samejima, F. (1969). Estimation of latent ability using a response pattern of graded
scores. \emph{Psychometrika Monograph Supplement, 34}(4, Pt. 2), 100.

Masters, G. N. (1982). A Rasch model for partial credit scoring.
\emph{Psychometrika, 47}, 149–174. doi: 10.1007/BF02296272
}
