% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim2D.R
\name{IarcCS.Te.onesixth}
\alias{IarcCS.Te.onesixth}
\title{The indicator for the presence of an arc from a point to another for Central Similarity Proximity Catch
Digraphs (CS-PCDs) - first one-sixth of the standard equilateral triangle case}
\usage{
IarcCS.Te.onesixth(p1, p2)
}
\arguments{
\item{p1}{A 2D point whose CS proximity region is constructed.}

\item{p2}{A 2D point. The function determines whether \code{p2} is inside the CS proximity region of
\code{p1} or not.}
}
\value{
\eqn{I(}\code{p2} is in \eqn{N_{CS}(p1,t=1))} for \code{p1} in the first one-sixth of \eqn{T_e},
\eqn{T(A,D_3,CM)}, that is, returns 1 if \code{p2} is in \eqn{N_{CS}(p1,t=1)}, returns 0 otherwise
}
\description{
Returns \eqn{I(}\code{p2} is in \eqn{N_{CS}(p1,t=1))} for points \code{p1} and \code{p2},
that is, returns 1 if \code{p2} is in \eqn{N_{CS}(p1,t=1)},
returns 0 otherwise, where \eqn{N_{CS}(x,t=1)} is the CS proximity region for point \eqn{x} with expansion parameter \eqn{t=1}.

CS proximity region is defined with respect to the standard equilateral triangle
\eqn{T_e=T(A,B,C)=T((0,0),(1,0),(1/2,\sqrt{3}/2))} and edge regions are based on the center of mass \eqn{CM=(1/2,\sqrt{3}/6)}.
Here \code{p1} must lie in the first one-sixth of \eqn{T_e}, which is the triangle with vertices \eqn{T(A,D_3,CM)=T((0,0),(1/2,0),CM)}.
If \code{p1} and \code{p2} are distinct and \code{p1} is outside of \eqn{T(A,D_3,CM)} or \code{p2} is outside \eqn{T_e}, it returns 0,
but if they are identical, then it returns 1 regardless of their locations (i.e., it allows loops).
}
\seealso{
\code{\link{IarcCSstd.tri}}
}
\author{
Elvan Ceyhan
}
