% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim1D.R
\name{inci.matCSint}
\alias{inci.matCSint}
\title{Incidence matrix for Central Similarity Proximity Catch Digraphs (CS-PCDs)
for 1D data - one interval case}
\usage{
inci.matCSint(Xp, int, t, c = 0.5)
}
\arguments{
\item{Xp}{a set of 1D points which constitutes the vertices of the digraph.}

\item{int}{A \code{vector} of two real numbers representing an interval.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside middle intervals
with the default \code{c=.5}.
For the interval, \code{int}\eqn{=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}
}
\value{
Incidence matrix for the CS-PCD with vertices being 1D data set, \code{Xp},
and \code{int} determines the end points of the intervals (in the one interval case)
}
\description{
Returns the incidence matrix for the CS-PCD for a given 1D numerical data set, \code{Xp},
as the vertices of the digraph and \code{int} determines the end points of the interval (in the one interval case).
Loops are allowed, so the diagonal entries are all equal to 1.

CS proximity region is constructed
with an expansion parameter \eqn{t > 0} and a centrality parameter \eqn{c \in (0,1)}.

See also (\insertCite{ceyhan:revstat-2016;textual}{pcds}).
}
\examples{
\donttest{
c<-.4
t<-1
a<-0; b<-10; int<-c(a,b)

xf<-(int[2]-int[1])*.1

set.seed(123)

n<-10
Xp<-runif(n,a-xf,b+xf)

IM<-inci.matCSint(Xp,int,t,c)
IM

dom.num.greedy(IM)
Idom.num.up.bnd(IM,3)
dom.num.exact(IM)

inci.matCSint(Xp,int+10,t,c)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{inci.matCS1D}}, \code{\link{inci.matPE1D}},
\code{\link{inci.matPEtri}}, and \code{\link{inci.matPE}}
}
\author{
Elvan Ceyhan
}
