% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassFunctions.R
\name{print.NumArcs}
\alias{print.NumArcs}
\title{Print a \code{NumArcs} \code{object}}
\usage{
\method{print}{NumArcs}(x, ...)
}
\arguments{
\item{x}{A \code{NumArcs} \code{object}.}

\item{\dots}{Additional arguments for the S3 method \code{'print'}.}
}
\value{
The \code{call} of the \code{object} of class \code{"NumArcs"}
and also the \code{desc} (i.e. a brief description)
of the output: number of arcs in the proximity catch digraph (PCD) and
related quantities in the induced subdigraphs for points in the Delaunay cells.
}
\description{
Prints the \code{call} of the \code{object}
of class \code{"NumArcs"}
and also the \code{desc} (i.e. a brief description) of the output.
}
\examples{
\donttest{
nx<-15; ny<-5;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-cbind(runif(nx),runif(nx))
Yp<-cbind(runif(ny,0,.25),runif(ny,0,.25))+cbind(c(0,0,0.5,1,1),c(0,1,.5,0,1))
#try also Yp<-cbind(runif(ny,0,1),runif(ny,0,1))

M<-"CC"  #try also M<-c(1,1,1)

Narcs<-num.arcsAS(Xp,Yp,M)
Narcs
print(Narcs)

typeof(Narcs)
attributes(Narcs)
}

}
\seealso{
\code{\link{summary.NumArcs}}, \code{\link{print.summary.NumArcs}},
and \code{\link{plot.NumArcs}}
}
