% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassFunctions.R
\name{print.Uniform}
\alias{print.Uniform}
\title{Print a \code{Uniform} \code{object}}
\usage{
\method{print}{Uniform}(x, ...)
}
\arguments{
\item{x}{A \code{Uniform} \code{object}.}

\item{\dots}{Additional arguments for the S3 method \code{'print'}.}
}
\value{
The \code{call} of the \code{object} of class \code{"Uniform"}
and also the \code{type}
(i.e. a brief description) of the uniform distribution).
}
\description{
Prints the \code{call} of the \code{object} of class \code{"Uniform"}
and also the \code{type}
(i.e. a brief description) of the uniform distribution).
}
\examples{
\donttest{
n<-10 #try also 20, 100, and 1000
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C)

Xdt<-runif.tri(n,Tr)
Xdt
print(Xdt)

typeof(Xdt)
attributes(Xdt)
}

}
\seealso{
\code{\link{summary.Uniform}},
\code{\link{print.summary.Uniform}},
and \code{\link{plot.Uniform}}
}
