% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_tools.R
\name{check_directory_structure}
\alias{check_directory_structure}
\title{Check if a directory structure matches the expected structure}
\usage{
check_directory_structure(
  root_path,
  expected_structure,
  only_missing = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{root_path}{A character string specifying the root directory to check.}

\item{expected_structure}{A character vector specifying the expected directory structure.
Each element should be a relative path (e.g., "data/raw").}

\item{only_missing}{Only check the missing files/directories.}

\item{verbose}{A logical value. If \code{TRUE}, prints detailed information; if \code{FALSE}, suppresses output.}
}
\value{
A logical value: \code{TRUE} if the directory structure matches the expected structure,
otherwise \code{FALSE}.
}
\description{
This function compares the actual directory structure with a predefined expected structure
and returns \code{TRUE} if they match, otherwise \code{FALSE}. If \code{verbose} is \code{TRUE}, it prints
detailed information about missing or extra files/directories.
}
