% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcs_per.R
\name{rcs_per}
\alias{rcs_per}
\title{Generate design matrix for periodic restricted cubic spline}
\usage{
rcs_per(x, knots = NULL, nk = 5, xmin = min(x, na.rm = TRUE),
  xmax = max(x, na.rm = TRUE))
}
\arguments{
\item{x}{numerical x values to transform to new basis}

\item{knots}{vector with locations of the knots of the spline}

\item{nk}{number of knots, used only if the knots are not specified, overridden otherwise}

\item{xmin}{value of the (theoretical) minimum of x}

\item{xmax}{value of the (theoretical) maximum of x

#' @examples 
# load example data; see help("viral_east_mediteranean")
data("viral_east_mediteranean")

# calculate location of knots to use
Knots <- 
 Hmisc::rcspline.eval(x = viral_east_mediteranean$EpiWeek,
                      nk = 5, knots.only = TRUE)

# model viral infections vs weeks
model <- glm(RSV ~ rcs_per(EpiWeek, knots = Knots), data = viral_east_mediteranean)

# plot model (with many points, to make it smooth)
plot_per_mod(Model = model, XvarName = "EpiWeek", Smooth = TRUE)}
}
\description{
Generate design matrix for periodic restricted cubic spline.
}
