## Purpose: Test script for pedgene package
## Testing a simple 10-variant gene on both the X chrom and autosome
## Authors: Dan Schaid and Jason Sinnwell
## Created: 19-AUG-2013
## Updated: 9/8/2025

devel=FALSE
if(devel) {
  .libPaths(c("/projects/bsi/pharmacogenetics/s212953.SchaidMethods/PedGene/Build/gitbranch/renv/library/R-4.4/x86_64-pc-linux-gnu/",.libPaths()))
  library(CompQuadForm)
  library(Pedixplorer)
  library(survey)
  dir="../"
  rfiles <- list.files("../R/", pattern="*.R", full=TRUE)
  for(rf in rfiles) source(rf)
  dfiles <- list.files(path=paste0(dir,"/data/"), pattern="*.RData$")
  for(d in dfiles) load(paste0(dir, "/data/",d))

} else {
  ## alternatively:
  
  require(pedgene)

  data(example.ped)
  data(example.geno)
  data(example.map)
}



## simple tests of two genes (10 variants each)
## the genes are same variants, just on chroms 1 and X
pg.m2 <- pedgene(example.ped, example.geno, example.map, male.dose=2)

pg.m1 <- pedgene(example.ped, example.geno, example.map, male.dose=1)


## saved objects are of class pedgene, with items call (function call)
## and pgdf, a data.frame with a row for each gene
class(pg.m2)
names(pg.m2)


print(pg.m2, digits=4)


print(pg.m1, digits=4)

summary(pg.m2)

## Testing first gene with dose=2-dose
geno.recode <- cbind(example.geno[,1:2], 2-example.geno[,grep("AA", names(example.geno))])
pg.recode <- pedgene(example.ped, geno.recode, male.dose=2)

## note when map not given, assumes all 1 gene, and assigns "unknown" gene/chrom
pg.recode
