#' Pedometric Tools and Techniques
#'
#' This package contains many tools and techniques used in the field of pedometrics (see
#' https://en.wikipedia.org/wiki/Pedometric_mapping for a definition of _pedometrics_). These tools
#' and techniques were developed to fulfill the demands created by the PhD research project
#' (2012-2016) entitled \dQuote{Contribution to the Construction of Models for Predicting Soil
#' Properties}, developed by Alessandro Samuel-Rosa under the supervision of Dr Lúcia HC Anjos
#' (Universidade Federal Rural do Rio de Janeiro, Brazil), Dr Gustavo M Vasques (Embrapa Solos,
#' Brazil), and Dr Gerard B M Heuvelink (ISRIC - World Soil Information, the Netherlands). The
#' project is/was funded by the CNPq Foundation (Process 140720/2012-0), Ministry of Science
#' and Technology of Brazil, Brasília, DF, 70040-020, Brazil, phone +55 (61) 2022 6002, and the
#' CAPES Foundation (Process ID BEX 11677/13-9), Ministry of Education of Brazil, Brasília, DF,
#' 70040-020, Brazil, phone: +55 (61) 2022 6210.
#'
#' Several functions simply extend the functionalities of other functions commonly used for the
#' analysis of pedometric data. It should be noted that changes are likely to occur quite often and
#' the use of this package as a dependency for other packages is strongly discouraged.
#'
# General information ##############################################################################
#' @author Author and Maintainer: Alessandro Samuel-Rosa \email{alessandrosamuelrosa@@gmail.com}.
#' @name pedometrics-package
#' @aliases pedometrics-package pedometrics
#' @docType package
#' @useDynLib pedometrics
NULL
