% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{coef,penfa-method}
\alias{coef,penfa-method}
\title{Coefficients from a \code{penfa} object}
\usage{
\S4method{coef}{penfa}(object, type = "free", labels = TRUE)
}
\arguments{
\item{object}{An object of class \code{penfa}, found as a result of a call
to \code{penfa}.}

\item{type}{Character. If \code{type="free"}, only the estimated parameters
(both penalized and unpenalized) are returned. If \code{type="user"}, all
parameters listed in the parameter table are returned, including fixed
parameters.}

\item{labels}{Logical. If \code{TRUE}, parameters are returned with their
names.}
}
\value{
A numeric vector of class \code{penfa.vector} containing the
estimated model parameters.
}
\description{
An S4 method returning the estimates of the model parameters.
}
\examples{


data(ccdata)

syntax = 'help  =~   h1 + h2 + h3 + h4 + h5 + h6 + h7 + 0*v1 + v2 + v3 + v4 + v5
          voice =~ 0*h1 + h2 + h3 + h4 + h5 + h6 + h7 +   v1 + v2 + v3 + v4 + v5'

alasso_fit <- penfa(## factor model
                    model  = syntax,
                    data   = ccdata,
                    std.lv = TRUE,
                    ## penalization
                    pen.shrink = "alasso",
                    eta = list(shrink = c("lambda" = 0.01), diff = c("none" = 0)),
                    ## automatic procedure
                    strategy = "auto")

coef(alasso_fit)




}
\seealso{
\code{\link{penfa}}, \code{\link{penfa-class}}
}
