% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\docType{class}
\name{penfaModel-class}
\alias{penfaModel-class}
\title{S4 Class for internal representation of a factor model}
\description{
The \code{penfaModel} class gives the internal matrix
representation of a factor analysis model. Note that this representation
summarizes the characteristics of the model itself (e.g., number of items,
number of factors, parameter indices, etc), without information on the
penalization process (see \code{\linkS4class{penfaPenalty}} for that
aspect). This class is an adaptation of the \code{lavModel} class from the
\href{https://CRAN.R-project.org/package=lavaan}{lavaan} package.
}
\section{Slots}{

\describe{
\item{\code{GLIST}}{List. The model matrices and vectors: "lambda" for the factor
loading matrix, "psi" for the covariance matrix of the unique factors,
"phi" for the covariance matrix of the common factors, "tau" for the
intercept vector, and "kappa" for the vector of factor means. In case of a
multiple-group analysis, the elements of each group are presented
sequentially.}

\item{\code{dimNames}}{List. Dimension names (row names and column names) of every
model matrix and vector.}

\item{\code{isSymmetric}}{Logical vector declaring whether each model matrix/vector
is symmetric.}

\item{\code{mmSize}}{Integer vector specifying the size (unique elements only) of
each model matrix/vector.}

\item{\code{meanstructure}}{Logical. It declares whether the model includes a
meanstructure.}

\item{\code{ngroups}}{Integer. The number of groups.}

\item{\code{nmat}}{Integer vector specifying the number of model matrices/vectors for
each group.}

\item{\code{nvar}}{Integer vector specifying the number of observed variables in each
group.}

\item{\code{num.idx}}{List of the indices of the observed variables in each group.}

\item{\code{nx.free}}{Integer. The number of parameters of the factor model. This
count does not include the fixed parameters, but it does include the
parameters that will be penalized (if any) during optimization. (see
\code{\linkS4class{penfaPenalty}} for additional details in this respect).}

\item{\code{nx.user}}{Integer. The total count of the parameters that are being
estimated and the ones that have been fixed.}

\item{\code{m.free.idx}}{List. For each model matrix, the indices of the elements to
be estimated (i.e., non-fixed). The counter starts at 1 for every model
matrix.}

\item{\code{x.free.idx}}{List. For each model matrix, the indices of the elements to
be estimated (i.e., non-fixed). The counter continues from the previous
model matrix.}

\item{\code{m.user.idx}}{List. Much like \code{m.free.idx}, but it also contains the
indices of the parameters that have been fixed by the user.}

\item{\code{x.user.idx}}{List. Much like \code{x.free.idx}, but it also contains the
indices of the parameters that have been fixed by the user.}

\item{\code{x.free.var.idx}}{Vector of integers denoting the indices corresponding to
the unique variances.}
}}

\examples{

data(ccdata)

syntax = 'help  =~   h1 + h2 + h3 + h4 + h5 + h6 + h7 + 0*v1 + v2 + v3 + v4 + v5
          voice =~ 0*h1 + h2 + h3 + h4 + h5 + h6 + h7 +   v1 + v2 + v3 + v4 + v5'

alasso_fit <- penfa(## factor model
                    model  = syntax,
                    data   = ccdata,
                    std.lv = TRUE,
                    ## penalization
                    pen.shrink = "alasso",
                    eta = list(shrink = c("lambda" = 0.01), diff = c("none" = 0)),
                    ## automatic procedure
                    strategy = "auto")

alasso_fit@Model

}
\seealso{
\code{\link{penfa}}
}
