% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gibbs}
\alias{gibbs}
\title{Runs the Gibbs sampler}
\usage{
gibbs(
  U0,
  ftgrid,
  time,
  status,
  a_rates,
  b_rates,
  cohesion,
  a_beta,
  b_beta,
  npost,
  nburnin,
  nlag
)
}
\arguments{
\item{U0}{vector of change point indicators}

\item{ftgrid}{vector of indexes of distinct failure times}

\item{time}{vector of observed failure times.}

\item{status}{vector of failure indicators}

\item{a_rates}{shape parameter of the gamma distribution (prior for failure rates).}

\item{b_rates}{scale parameter of the gamma distribution (prior for failure rates).}

\item{cohesion}{type of prior cohesion (1 to 4).}

\item{a_beta}{shape1 parameter of the beta distribution (prior for p - cohesion 4).}

\item{b_beta}{shape2 parameter of the beta distribution (prior for p - cohesion 4).}

\item{npost}{desired posterior sample size}

\item{nburnin}{number of iterations to be discarded.}

\item{nlag}{number of jumps to eliminate autocorrelation of the chain.}
}
\value{
posterior sample
}
\description{
Runs the Gibbs sampler
}
