% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{checkSection}
\alias{checkSection}
\alias{checkSection,Config-method}
\title{Check for existence of a section in the Project config}
\usage{
checkSection(object, sectionNames)

\S4method{checkSection}{Config}(object, sectionNames)
}
\arguments{
\item{object}{object of \code{"\linkS4class{Config}"}}

\item{sectionNames}{the name of the section or names of the
nested sections to look for}
}
\value{
a logical indicating whether the section exists
}
\description{
This function checks for the section/nested sections in the config YAML file.
 Returns \code{TRUE} if it exist(s) or \code{FALSE} otherwise.
}
\details{
Element indices can be used instead of the actual names, see \code{Examples}.
}
\section{Methods (by class)}{
\itemize{
\item \code{checkSection(Config)}: checks for existence of a section in \code{"\linkS4class{Config}"} objects

}}
\examples{
projectConfig = system.file("extdata", "example_peps-master",
"example_amendments1", "project_config.yaml", package="pepr")
p=Project(projectConfig)
checkSection(config(p),sectionNames = c("amendments","newLib"))
checkSection(config(p),sectionNames = c("amendments",1))
}
